/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.common.golem;

import com.zkryle.jeg.common.ICoreOwner;
import com.zkryle.jeg.common.customgoals.CoreOwnerFollowOwnerGoal;
import com.zkryle.jeg.common.customgoals.CoreOwnerLookAtGoal;
import com.zkryle.jeg.common.customgoals.CoreOwnerLookRandomlyGoal;
import com.zkryle.jeg.common.customgoals.CoreOwnerMeleeAttackGoal;
import com.zkryle.jeg.common.customgoals.CoreOwnerWaterAvoidingRandomWalkingGoal;
import com.zkryle.jeg.common.golem.EnragedGolemSpikeEntity;
import com.zkryle.jeg.core.Init;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EnragedMagmaticGolemEntity
extends TameableEntity
implements ICoreOwner,
IEntityAdditionalSpawnData {
    private float fallingSpeed = 0.0f;
    private short coreDischargeCounter = (short)1200;
    public float headInclination;
    public float bodyInclination;
    public float altBodyInclination;
    private ItemStack core = ItemStack.field_190927_a;
    private boolean isOn = false;
    private int attackAnimationTick;
    private int rangedAttackAnimationTick;
    private byte coreDelay = (byte)80;
    private boolean soundFlag;

    public EnragedMagmaticGolemEntity(EntityType<? extends TameableEntity> p_i48574_1_, World p_i48574_2_) {
        super(p_i48574_1_, p_i48574_2_);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 30.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SpikeAttackGoal(this, 11.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new CoreOwnerMeleeAttackGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new CoreOwnerFollowOwnerGoal(this, 1.0, 7.5f, 2.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new CoreOwnerWaterAvoidingRandomWalkingGoal(this, 0.9));
        this.field_70714_bg.func_75776_a(5, (Goal)new CoreOwnerLookAtGoal(this, LivingEntity.class, 4.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new CoreOwnerLookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, p_234199_0_ -> p_234199_0_ instanceof IMob && !(p_234199_0_ instanceof ZombifiedPiglinEntity)));
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    @Override
    public boolean hasCore() {
        return !this.core.func_190926_b();
    }

    @Override
    public void setCore(ItemStack core) {
        this.core = core;
    }

    @Override
    public ItemStack getCore() {
        return this.core;
    }

    @Override
    public boolean isDelayElapsed() {
        return this.coreDelay <= 0;
    }

    public void func_70071_h_() {
        if (this.getCorePercentage() <= 2.0f && this.isOn()) {
            this.setOn(false);
        } else if (this.getCorePercentage() > 2.0f && !this.isOn()) {
            this.setOn(true);
        }
        if (!this.isOn()) {
            if (this.bodyInclination < 1.055f) {
                this.fallingSpeed += 0.0025f;
            }
            if (this.headInclination > -0.5f) {
                this.headInclination -= 0.05f;
            }
            if (this.bodyInclination < 1.055f && this.headInclination < -0.25f) {
                this.bodyInclination += this.fallingSpeed;
            }
        } else {
            if (this.headInclination < 0.0f && this.bodyInclination <= 0.0f) {
                this.headInclination += 0.05f;
            }
            if (this.bodyInclination > 0.0f) {
                this.bodyInclination -= 0.05f;
            }
            if (this.rangedAttackAnimationTick > 10 && this.altBodyInclination < 0.85f) {
                this.altBodyInclination += 0.3f;
            }
            this.fallingSpeed = 1.0E-4f;
        }
        if (this.rangedAttackAnimationTick <= 10 && this.altBodyInclination > 0.0f) {
            this.altBodyInclination -= 0.15f;
        }
        if (Math.floor(this.bodyInclination * 10.0f) == 9.0 && !this.hasCore()) {
            this.spawnHitParticles(30);
            this.soundFlag = true;
            if (!this.field_70170_p.func_201670_d()) {
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)Init.GROUND_PUNCH.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if (Math.floor(this.bodyInclination * 10.0f) == 1.0 && !this.hasCore() && this.soundFlag && !this.field_70170_p.func_201670_d()) {
            this.soundFlag = false;
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)Init.GOLEM_EXTRACTING_CORE.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        if (this.isOn()) {
            this.coreDischargeCounter = (short)(this.coreDischargeCounter - 1);
            if (this.coreDischargeCounter <= 0) {
                this.coreDischargeCounter = (short)1200;
                if (!this.field_70170_p.func_201670_d()) {
                    this.core.func_96631_a(5, new Random(), null);
                }
            }
        }
        this.coreDelay = (byte)(this.coreDelay - 1);
        this.coreDelay = (byte)Math.max(0, this.coreDelay);
        super.func_70071_h_();
    }

    public void spawnHitParticles(int amountOfParticles) {
        Vector3d particlePos = this.func_213303_ch().func_178787_e(this.func_70040_Z());
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.field_70170_p.func_180495_p(new BlockPos(particlePos).func_177977_b())), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), amountOfParticles, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.1);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity pPlayer, Hand pHand) {
        if (pPlayer.func_184586_b(pHand).func_77973_b() == Init.NETHER_CORE_ITEM.get() && !this.hasCore() && this.bodyInclination >= 1.055f) {
            this.coreDelay = (byte)80;
            this.setCore(pPlayer.func_184586_b(pHand).func_77946_l());
            pPlayer.func_184611_a(pHand, ItemStack.field_190927_a);
            if (this.getCorePercentage() > 2.0f) {
                this.core.func_96631_a(20, new Random(), null);
            }
            if (!pPlayer.func_225608_bj_()) {
                this.setTamed(pPlayer);
            }
            this.field_70170_p.func_184133_a(pPlayer, this.func_233580_cy_().func_177984_a(), (SoundEvent)Init.INSERTING_CORE_GOLEM.get(), SoundCategory.NEUTRAL, 0.5f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        if (pPlayer.func_184586_b(pHand).func_190926_b() && this.hasCore() && (this.bodyInclination <= 0.0f || this.getCorePercentage() <= 2.0f) && (this.func_184753_b() == null || this.func_184753_b().equals(pPlayer.func_110124_au()))) {
            pPlayer.func_184611_a(pHand, this.core.func_77946_l());
            this.setCore(ItemStack.field_190927_a);
            if (this.func_70909_n() && this.func_184753_b().equals(pPlayer.func_110124_au())) {
                this.setUnTamed();
            }
            this.soundFlag = true;
            return ActionResultType.SUCCESS;
        }
        if (pPlayer.func_184586_b(pHand).func_77973_b() == Init.MAGMATIC_OBSIDIAN_ITEM.get() && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!pPlayer.field_71075_bZ.field_75098_d) {
                pPlayer.func_184586_b(pHand).func_190918_g(1);
            }
            this.func_184185_a(SoundEvents.field_226143_fP_, 1.0f, 1.0f);
            this.func_70691_i(16.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public void setOn(boolean on) {
        this.isOn = on;
    }

    public boolean func_70039_c(CompoundNBT pCompound) {
        CompoundNBT core = new CompoundNBT();
        this.core.func_77955_b(core);
        pCompound.func_218657_a("CORE", (INBT)core);
        return super.func_70039_c(pCompound);
    }

    public void func_70020_e(CompoundNBT pCompound) {
        this.setCore(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)pCompound.func_74781_a("CORE"))).func_77946_l());
        super.func_70020_e(pCompound);
    }

    protected void func_213337_cE() {
        this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.core.func_77946_l()));
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150788_a(this.core.func_77946_l());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.setCore(additionalData.func_150791_c().func_77946_l());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)Init.ENRAGED_MAGMATIC_GOLEM_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)Init.ENRAGED_MAGMATIC_GOLEM_DIES.get();
    }

    public boolean func_70652_k(Entity pEntity) {
        boolean fireFlag;
        this.attackAnimationTick = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : f;
        boolean flag = pEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f1);
        if (flag) {
            boolean flag1 = new Random().nextInt(20) == 5;
            pEntity.func_213317_d(pEntity.func_213322_ci().func_72441_c(this.func_70040_Z().func_82615_a() * (double)1.7f * (double)(flag1 ? 2.0f : 1.0f), (double)0.7f, this.func_70040_Z().func_82616_c() * (double)1.7f * (double)(flag1 ? 2.0f : 1.0f)));
            this.func_174815_a((LivingEntity)this, pEntity);
            for (Entity entity : pEntity.field_70170_p.func_72839_b(pEntity, new AxisAlignedBB(pEntity.func_233580_cy_().func_177965_g(2).func_177970_e(2).func_177977_b(), pEntity.func_233580_cy_().func_177964_d(2).func_177985_f(2).func_177984_a()))) {
                boolean flag2;
                if (entity instanceof EnragedMagmaticGolemEntity) continue;
                boolean bl = flag2 = !(entity instanceof ItemEntity);
                if (flag2) {
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f1 / 8.0f);
                }
                float v = 1.2f * (flag1 ? 2.0f : 1.0f);
                entity.func_213317_d(pEntity.func_213322_ci().func_72441_c(this.func_70040_Z().func_82615_a() * (double)v, (double)0.7f, this.func_70040_Z().func_82616_c() * (double)v));
            }
        }
        boolean bl = fireFlag = new Random().nextInt(100) < 10;
        if (fireFlag) {
            pEntity.func_70015_d(10);
        }
        this.func_184185_a((SoundEvent)Init.ENRAGED_MAGMATIC_GOLEM_ATTACK.get(), 0.7f, 1.0f);
        return flag;
    }

    private float getAttackDamage() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_) * (this.getCorePercentage() / 100.0f);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.rangedAttackAnimationTick > 0) {
            --this.rangedAttackAnimationTick;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte pId) {
        if (pId == 4) {
            this.attackAnimationTick = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else if (pId == 5) {
            this.rangedAttackAnimationTick = 20;
        } else {
            super.func_70103_a(pId);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public void performPreRangedAttackAnimation() {
        this.rangedAttackAnimationTick = 20;
        this.field_70170_p.func_72960_a((Entity)this, (byte)5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRangedAttackAnimationTick() {
        return this.rangedAttackAnimationTick;
    }

    @Deprecated
    public void setTamed(PlayerEntity pPlayer) {
        this.func_193101_c(pPlayer);
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
    }

    @Deprecated
    public void setUnTamed() {
        this.func_70903_f(false);
        this.func_184754_b(null);
    }

    public boolean func_230279_az_() {
        return true;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a((SoundEvent)Init.ENRAGED_MAGMATIC_GOLEM_STEP.get(), 0.4f, 1.0f);
        super.func_180429_a(p_180429_1_, p_180429_2_);
    }

    public void func_70623_bb() {
    }

    public class SpikeAttackGoal
    extends Goal {
        private final EnragedMagmaticGolemEntity golem;
        private final float distanceToActivate;
        private long lastCanUseCheck = 0L;
        private int animationDelay;

        public SpikeAttackGoal(EnragedMagmaticGolemEntity pEntity, float pDistance) {
            this.golem = pEntity;
            this.distanceToActivate = pDistance;
        }

        public boolean func_75250_a() {
            LivingEntity target = this.golem.func_70638_az();
            if (this.golem.isDelayElapsed() && this.golem.getCorePercentage() >= 50.0f && this.golem.field_70170_p.func_82737_E() - this.lastCanUseCheck > 100L) {
                if (target == null) {
                    return false;
                }
                if (!target.func_70089_S()) {
                    return false;
                }
                if (this.golem.func_70032_d((Entity)target) >= this.distanceToActivate && this.isReachable(target)) {
                    this.lastCanUseCheck = this.golem.field_70170_p.func_82737_E();
                    return true;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            LivingEntity target = this.golem.func_70638_az();
            return this.animationDelay > 0 || target != null && !target.func_70089_S() && this.golem.func_70032_d((Entity)target) >= this.distanceToActivate && this.isReachable(target) && this.golem.getCorePercentage() >= 50.0f;
        }

        public void func_75249_e() {
            this.golem.func_213395_q(true);
            this.animationDelay = 10;
            this.golem.performPreRangedAttackAnimation();
            if (!this.golem.field_70170_p.func_201670_d()) {
                this.golem.field_70170_p.func_184133_a(null, this.golem.func_233580_cy_(), (SoundEvent)Init.GROUND_PUNCH.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }

        public void func_75251_c() {
            if (this.animationDelay <= 0) {
                LivingEntity livingentity = this.golem.func_70638_az();
                if (!EntityPredicates.field_188444_d.test(livingentity)) {
                    this.golem.func_70624_b(null);
                }
                this.golem.func_213395_q(false);
                this.golem.func_70661_as().func_75499_g();
            }
        }

        public void func_75246_d() {
            this.animationDelay = Math.max(0, --this.animationDelay);
            this.golem.field_70699_by.func_75499_g();
            if (this.animationDelay == 0 && this.golem.func_70638_az() != null) {
                this.performAttack(this.golem.func_70638_az(), this.golem.func_70032_d((Entity)this.golem.func_70638_az()));
                this.golem.spawnHitParticles(100);
            }
        }

        private void performAttack(LivingEntity target, double distanceToTarget) {
            this.golem.getCore().func_96631_a(3, new Random(), null);
            float f = (float)MathHelper.func_181159_b((double)(target.func_226281_cx_() - this.golem.func_226281_cx_()), (double)(target.func_226277_ct_() - this.golem.func_226277_ct_()));
            int l = 0;
            while ((double)l < distanceToTarget) {
                double d2 = 1.25 * ((double)l - 3.0);
                int j = 1 * l;
                if (!this.golem.field_70170_p.func_201670_d()) {
                    BlockPos pos = new BlockPos(this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, target.func_226278_cu_() - 1.0, this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2);
                    if (this.golem.field_70170_p.func_180495_p(pos).func_224755_d((IBlockReader)target.field_70170_p, pos, Direction.UP)) {
                        ((ServerWorld)this.golem.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, target.field_70170_p.func_180495_p(pos)), this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, target.func_226278_cu_() - 0.25, this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, (int)(distanceToTarget - (double)l), 0.0, 0.0, 0.0, (distanceToTarget - (double)l) * 2.0);
                        if (target.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) {
                            ((ServerWorld)this.golem.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_239819_as_, this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, target.func_226278_cu_() - 0.25, this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, (int)distanceToTarget, 0.0, 0.0, 0.0, 0.5);
                        }
                        target.field_70170_p.func_184133_a(null, pos, (SoundEvent)Init.ENRAGED_GOLEM_SPIKE_ATTACK.get(), SoundCategory.BLOCKS, 0.7f, 1.0f);
                    } else if (this.golem.field_70170_p.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)target.field_70170_p, pos.func_177977_b(), Direction.UP)) {
                        ((ServerWorld)this.golem.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, target.field_70170_p.func_180495_p(pos.func_177977_b())), this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, target.func_226278_cu_() - 1.25, this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, (int)(distanceToTarget - (double)l), 0.0, 0.0, 0.0, (distanceToTarget - (double)l) * 2.0);
                        if (target.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150350_a) {
                            ((ServerWorld)this.golem.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_239819_as_, this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, target.func_226278_cu_() - 1.25, this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, (int)distanceToTarget, 0.0, 0.0, 0.0, 0.5);
                        }
                        target.field_70170_p.func_184133_a(null, pos.func_177977_b(), (SoundEvent)Init.ENRAGED_GOLEM_SPIKE_ATTACK.get(), SoundCategory.BLOCKS, 0.7f, 1.0f);
                    }
                }
                ++l;
            }
            for (int i = 0; i < 5; ++i) {
                float f1 = f + (float)i * (float)Math.PI * 0.4f;
                BlockPos pos = new BlockPos(this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * 1.25 * (double)((int)(distanceToTarget - 2.0)) + (double)MathHelper.func_76134_b((float)f1) * 1.9, (double)target.func_233580_cy_().func_177956_o(), this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * (double)((int)(distanceToTarget - 2.0)) + (double)MathHelper.func_76126_a((float)f1) * 1.9);
                if (target.field_70170_p.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)target.field_70170_p, pos, Direction.UP)) {
                    target.field_70170_p.func_217376_c((Entity)EnragedGolemSpikeEntity.createEnragedGolemSpikeEntity(target.field_70170_p, this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * 1.25 * (double)((int)(distanceToTarget - 2.0)) + (double)MathHelper.func_76134_b((float)f1) * 1.9, target.func_233580_cy_().func_177956_o(), this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * (double)((int)(distanceToTarget - 2.0)) + (double)MathHelper.func_76126_a((float)f1) * 1.9, f));
                    continue;
                }
                if (!target.field_70170_p.func_180495_p(pos.func_177979_c(2)).func_224755_d((IBlockReader)target.field_70170_p, pos.func_177977_b(), Direction.UP)) continue;
                target.field_70170_p.func_217376_c((Entity)EnragedGolemSpikeEntity.createEnragedGolemSpikeEntity(target.field_70170_p, this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * 1.25 * (double)((int)(distanceToTarget - 2.0)) + (double)MathHelper.func_76134_b((float)f1) * 1.9, target.func_233580_cy_().func_177977_b().func_177956_o(), this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * (double)((int)(distanceToTarget - 2.0)) + (double)MathHelper.func_76126_a((float)f1) * 1.9, f));
            }
            BlockPos pos = new BlockPos(this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * 1.25 * (double)((int)(distanceToTarget - 2.0)), (double)target.func_233580_cy_().func_177956_o(), this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * (double)((int)(distanceToTarget - 2.0)));
            if (target.field_70170_p.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)target.field_70170_p, pos, Direction.UP)) {
                target.field_70170_p.func_217376_c((Entity)EnragedGolemSpikeEntity.createEnragedGolemSpikeEntity(target.field_70170_p, this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * 1.25 * (double)((int)(distanceToTarget - 2.0)), target.func_233580_cy_().func_177956_o(), this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * (double)((int)(distanceToTarget - 2.0)), f));
            } else if (target.field_70170_p.func_180495_p(pos.func_177979_c(2)).func_224755_d((IBlockReader)target.field_70170_p, pos.func_177977_b(), Direction.UP)) {
                target.field_70170_p.func_217376_c((Entity)EnragedGolemSpikeEntity.createEnragedGolemSpikeEntity(target.field_70170_p, this.golem.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * 1.25 * (double)((int)(distanceToTarget - 2.0)), target.func_233580_cy_().func_177977_b().func_177956_o(), this.golem.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * (double)((int)(distanceToTarget - 2.0)), f));
            }
        }

        private boolean isReachable(LivingEntity pTarget) {
            return this.golem.func_233580_cy_().func_177956_o() == pTarget.func_233580_cy_().func_177956_o() || this.golem.func_233580_cy_().func_177977_b().func_177956_o() == pTarget.func_233580_cy_().func_177956_o() || this.golem.func_233580_cy_().func_177979_c(2).func_177956_o() == pTarget.func_233580_cy_().func_177956_o() || this.golem.func_233580_cy_().func_177979_c(3).func_177956_o() == pTarget.func_233580_cy_().func_177956_o();
        }

        public boolean func_220685_C_() {
            return false;
        }
    }
}

